/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.workspace.WorkspaceWidget;

public class WorkspaceEvent {
    public static final int PAGE_ADDED = 1;
    public static final int PAGE_REMOVED = 2;
    public static final int BLOCK_ADDED = 3;
    public static final int BLOCK_REMOVED = 4;
    public static final int BLOCKS_CONNECTED = 5;
    public static final int BLOCKS_DISCONNECTED = 6;
    public static final int BLOCK_STACK_COMPILED = 7;
    public static final int PAGE_RENAMED = 8;
    public static final int PAGE_RESIZED = 9;
    public static final int BLOCK_RENAMED = 10;
    public static final int BLOCK_MOVED = 11;
    public static final int BLOCK_GENUS_CHANGED = 12;
    public static final int BLOCK_COMMENT_ADDED = 13;
    public static final int BLOCK_COMMENT_REMOVED = 14;
    public static final int BLOCK_COMMENT_MOVED = 15;
    public static final int BLOCK_COMMENT_RESIZED = 16;
    public static final int BLOCK_COMMENT_VISBILITY_CHANGE = 17;
    public static final int BLOCK_COMMENT_CHANGED = 18;
    public static final int WORKSPACE_FINISHED_LOADING = 100;
    private Long blockID = Block.NULL;
    private int eventType;
    private WorkspaceWidget widget = null;
    private BlockLink link = null;
    private String oldWidgetName = null;
    private boolean userSpawned = false;

    public WorkspaceEvent(WorkspaceWidget page, int eventType) {
        this.widget = page;
        this.eventType = eventType;
        this.blockID = Block.NULL;
    }

    public WorkspaceEvent(WorkspaceWidget page, int eventType, boolean userSpawned) {
        this.widget = page;
        this.eventType = eventType;
        this.blockID = Block.NULL;
        this.userSpawned = userSpawned;
    }

    public WorkspaceEvent(WorkspaceWidget page, String oldName, int eventType) {
        this.widget = page;
        this.eventType = eventType;
        this.blockID = Block.NULL;
        this.oldWidgetName = oldName;
    }

    public WorkspaceEvent(WorkspaceWidget page, String oldName, int eventType, boolean userSpawned) {
        this.widget = page;
        this.eventType = eventType;
        this.blockID = Block.NULL;
        this.oldWidgetName = oldName;
        this.userSpawned = userSpawned;
    }

    public WorkspaceEvent(WorkspaceWidget widget, Long blockID, int eventType) {
        this.widget = widget;
        this.eventType = eventType;
        this.blockID = blockID;
    }

    public WorkspaceEvent(WorkspaceWidget widget, Long blockID, int eventType, boolean userSpawned) {
        this.widget = widget;
        this.eventType = eventType;
        this.blockID = blockID;
        this.userSpawned = userSpawned;
    }

    public WorkspaceEvent(WorkspaceWidget widget, BlockLink link, int eventType) {
        this.widget = widget;
        this.link = link;
        this.eventType = eventType;
        this.blockID = Block.NULL;
    }

    public WorkspaceEvent(WorkspaceWidget widget, BlockLink link, int eventType, boolean userSpawned) {
        this.widget = widget;
        this.link = link;
        this.eventType = eventType;
        this.userSpawned = userSpawned;
    }

    public boolean isUserEvent() {
        return this.userSpawned;
    }

    public WorkspaceWidget getSourceWidget() {
        return this.widget;
    }

    public Long getSourceBlockID() {
        return this.blockID;
    }

    public int getEventType() {
        return this.eventType;
    }

    public BlockLink getSourceLink() {
        return this.link;
    }

    public String getOldNameOfSourceWidget() {
        return this.oldWidgetName;
    }

    public String toString() {
        switch (this.eventType) {
            case 1: {
                return "WorkspaceEvent(PAGE_ADDED: " + this.widget + ")";
            }
            case 2: {
                return "WorkspaceEvent(PAGE_REMOVED: " + this.widget + ")";
            }
            case 3: {
                return "WorkspaceEvent(BLOCK_ADDED: " + Block.getBlock(this.blockID) + ")";
            }
            case 4: {
                return "WorkspaceEvent(BLOCK_REMOVED: " + Block.getBlock(this.blockID) + ")";
            }
            case 5: {
                return "WorkspaceEvent(BLOCKS_CONNECTED: " + this.link + ")";
            }
            case 6: {
                return "WorkspaceEvent(BLOCKS_DISCONNECTED: " + this.link + ")";
            }
            case 7: {
                return "WorkspaceEvent(BLOCK_STACK_COMPILED: " + Block.getBlock(this.blockID) + ")";
            }
            case 8: {
                return "WorkspaceEvent(PAGE_RENAMED: " + this.widget + ")";
            }
            case 9: {
                return "WorkspaceEvent(PAGE_RESIZED: " + this.widget + ")";
            }
            case 10: {
                return "WorkspaceEvent(BLOCK_RENAMED: " + Block.getBlock(this.blockID) + ")";
            }
            case 11: {
                if (this.link == null) {
                    return "WorkspaceEvent(BLOCK_MOVED: " + Block.getBlock(this.blockID) + ")";
                }
                return "WorkspaceEvent(BLOCK_MOVED: " + this.link + ")";
            }
            case 12: {
                return "WorkspaceEvent(BLOCK_GENUS_CHANGED: " + Block.getBlock(this.blockID) + ")";
            }
            case 100: {
                return "WorkspaceEvent(WORKSPACE_FINISHED_LOADING)";
            }
        }
        return "WorkspaceEvent(" + this.eventType + ")";
    }
}

