/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace.typeblocking;

import edu.mit.blocks.codeblockutil.CTracklessScrollPane;
import edu.mit.blocks.renderable.BlockUtilities;
import edu.mit.blocks.renderable.TextualFactoryBlock;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.typeblocking.TypeBlockManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AutoCompletePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 328149080418L;
    private static final int MARGIN = 7;
    private static final Color BACKGROUND = new Color(230, 230, 150);
    private static final int MINIMUM_WIDTH = 105;
    private static final int MINIMUM_HEIGHT = 105;
    private int preferredWidth = 165;
    private int preferredHeight = 125;
    private final Font font = new Font("Ariel", 1, 12);
    private final JTextField editor = new JTextField();
    private final JList menu;
    private boolean resizing = false;

    public AutoCompletePanel() {
        super(new BorderLayout());
        this.editor.setFont(this.font);
        this.editor.setBackground(BACKGROUND);
        this.menu = new JList();
        this.menu.setFont(this.font);
        this.menu.setBackground(BACKGROUND);
        this.menu.setLayoutOrientation(0);
        CTracklessScrollPane menuPane = new CTracklessScrollPane(this.menu, 7, new Color(75, 50, 0), BACKGROUND){

            public Insets getInsets() {
                return new Insets(7, 0, 0, 0);
            }
        };
        menuPane.setBackground(BACKGROUND);
        this.menu.setCellRenderer(new QueryCellRenderer());
        this.setOpaque(false);
        this.setSize(this.preferredWidth, this.preferredHeight);
        this.add((Component)this.editor, "North");
        this.add((Component)menuPane, "Center");
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AutoCompletePanel.this.editor.requestFocus();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        EditorListener editorListener = new EditorListener();
        this.editor.getDocument().addDocumentListener(editorListener);
        this.editor.addFocusListener(editorListener);
        this.editor.addKeyListener(editorListener);
        MenuListener menuListener = new MenuListener();
        this.menu.addFocusListener(menuListener);
        this.menu.addMouseListener(menuListener);
        this.menu.addKeyListener(menuListener);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(BACKGROUND);
        g.fillRoundRect(0, 0, w - 1, h - 1, 14, 14);
        GeneralPath resize = new GeneralPath();
        resize.moveTo(w - 14, h);
        resize.lineTo(w, h - 14);
        resize.curveTo(w - 1, h - 1, w - 1, h - 1, w - 14, h);
        g.setColor(Color.gray);
        g2.fill(resize);
        g.setColor(Color.gray);
        g.drawRoundRect(0, 0, w - 1, h - 1, 14, 14);
        super.paint(g);
    }

    public Insets getInsets() {
        return new Insets(7, 7, 7, 7);
    }

    public void mousePressed(MouseEvent e) {
        if (e.getX() > this.getWidth() - 14 && e.getY() > this.getHeight() - 14) {
            this.resizing = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.resizing = false;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.resizing) {
            this.preferredWidth = e.getX() > 105 ? e.getX() : 105;
            this.preferredHeight = e.getY() > 105 ? e.getY() : 105;
            this.updateMenu();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void setText(String text) {
        this.editor.setText(text);
    }

    private void updateMenu() {
        List<TextualFactoryBlock> matchingBlocks;
        if (this.editor.getPreferredSize().width > this.preferredWidth) {
            this.setSize(this.editor.getPreferredSize().width, this.preferredHeight);
        } else {
            this.setSize(this.preferredWidth, this.preferredHeight);
        }
        String text = this.editor.getText().trim();
        try {
            Float.valueOf(text);
            matchingBlocks = BlockUtilities.getDigits(text);
        }
        catch (NumberFormatException e) {
            matchingBlocks = text.equals("+") ? BlockUtilities.getPlusBlocks(text) : BlockUtilities.getAllMatchingBlocks(text);
        }
        this.menu.setModel(new DefaultComboBoxModel<Object>(matchingBlocks.toArray()));
        this.revalidate();
        this.repaint();
    }

    private void displayBlock() {
        Object obj = this.menu.getSelectedValue();
        if (obj != null && obj instanceof TextualFactoryBlock) {
            this.setVisible(false);
            this.revalidate();
            this.repaint();
            try {
                Float.valueOf(obj.toString());
                TypeBlockManager.automateBlockInsertion((TextualFactoryBlock)obj, obj.toString());
            }
            catch (NumberFormatException e) {
                if (obj.toString().equals("+ [number]") || obj.toString().equals("+ [text]")) {
                    TypeBlockManager.automateBlockInsertion((TextualFactoryBlock)obj, obj.toString());
                }
                if (obj.toString().startsWith("\"")) {
                    String[] quote = obj.toString().split("\"");
                    TypeBlockManager.automateBlockInsertion((TextualFactoryBlock)obj, quote[1]);
                }
                TypeBlockManager.automateBlockInsertion((TextualFactoryBlock)obj);
            }
        }
    }

    private class QueryCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 328149080419L;

        private QueryCellRenderer() {
        }

        public void paint(Graphics g) {
            String query = AutoCompletePanel.this.editor.getText().toLowerCase().trim();
            String item = this.getText().toLowerCase();
            FontMetrics metrics = g.getFontMetrics();
            if (this.getBackground() != null) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setColor(Color.black);
            g.drawString(this.getText(), 2, this.getHeight() - metrics.getDescent());
            int index = item.indexOf(query);
            if (index != -1) {
                g.setColor(Color.red);
                g.drawString(this.getText().substring(index, index + query.length()), (int)metrics.getStringBounds(this.getText().substring(0, index), g).getWidth() + 2, this.getHeight() - metrics.getDescent());
            }
        }
    }

    private class MenuListener
    extends MouseAdapter
    implements FocusListener,
    KeyListener {
        public void focusGained(FocusEvent e) {
            AutoCompletePanel.this.revalidate();
            AutoCompletePanel.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            if (e.getOppositeComponent() == null || e.getOppositeComponent().equals(AutoCompletePanel.this.editor)) {
                return;
            }
            AutoCompletePanel.this.setVisible(false);
            AutoCompletePanel.this.revalidate();
            AutoCompletePanel.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                AutoCompletePanel.this.displayBlock();
            }
        }

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                AutoCompletePanel.this.displayBlock();
            } else if (e.getKeyChar() == '\u001b') {
                AutoCompletePanel.this.setVisible(false);
                AutoCompletePanel.this.revalidate();
                AutoCompletePanel.this.repaint();
                Workspace.getInstance().getBlockCanvas().getCanvas().requestFocus();
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class EditorListener
    extends KeyAdapter
    implements DocumentListener,
    FocusListener {
        public void changedUpdate(DocumentEvent e) {
            AutoCompletePanel.this.updateMenu();
        }

        public void insertUpdate(DocumentEvent e) {
            AutoCompletePanel.this.updateMenu();
        }

        public void removeUpdate(DocumentEvent e) {
            AutoCompletePanel.this.updateMenu();
        }

        public void focusGained(FocusEvent e) {
            AutoCompletePanel.this.revalidate();
            AutoCompletePanel.this.repaint();
            String lcOSName = System.getProperty("os.name").toLowerCase();
            boolean MAC_OS_X = lcOSName.startsWith("mac os x");
            if (MAC_OS_X) {
                AutoCompletePanel.this.editor.setText(AutoCompletePanel.this.editor.getText());
            }
        }

        public void focusLost(FocusEvent e) {
            if (e.getOppositeComponent() == null || e.getOppositeComponent().equals(AutoCompletePanel.this.menu)) {
                return;
            }
            AutoCompletePanel.this.setVisible(false);
            AutoCompletePanel.this.revalidate();
            AutoCompletePanel.this.repaint();
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                AutoCompletePanel.this.menu.setSelectedIndex(0);
                AutoCompletePanel.this.displayBlock();
            } else if (e.getKeyCode() == 40) {
                AutoCompletePanel.this.menu.setSelectedIndex(0);
                AutoCompletePanel.this.menu.requestFocus();
                AutoCompletePanel.this.menu.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
            } else if (e.getKeyChar() == '\u001b') {
                AutoCompletePanel.this.setVisible(false);
                AutoCompletePanel.this.revalidate();
                AutoCompletePanel.this.repaint();
                Workspace.getInstance().getBlockCanvas().getCanvas().requestFocus();
            }
        }
    }
}

