/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace.typeblocking;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.BlockLinkChecker;
import edu.mit.blocks.renderable.BlockNode;
import edu.mit.blocks.renderable.BlockUtilities;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.renderable.TextualFactoryBlock;
import edu.mit.blocks.workspace.BlockCanvas;
import edu.mit.blocks.workspace.PageChangeEventManager;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceWidget;
import edu.mit.blocks.workspace.typeblocking.AutoCompletePanel;
import edu.mit.blocks.workspace.typeblocking.BlockDropAnimator;
import edu.mit.blocks.workspace.typeblocking.FocusTraversalManager;
import edu.mit.blocks.workspace.typeblocking.KeyInputMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class TypeBlockManager {
    private static TypeBlockManager manager;
    private AutoCompletePanel autoCompletePanel = new AutoCompletePanel();
    private FocusTraversalManager focusManager;
    private BlockCanvas blockCanvas;
    static final String PLUS_OPERATION_LABEL = "+";
    static final String NUMBER_PLUS_OPERATION_LABEL = "+ [number]";
    static final String TEXT_PLUS_OPERATION_LABEL = "+ [text]";
    static final String EMPTY_LABEL_NAME = "";
    static final String QUOTE_LABEL = "\"";
    JFrame frame;
    private BlockNode bufferedBlock = null;

    public static TypeBlockManager enableTypeBlockManager(BlockCanvas component) {
        if (manager == null) {
            manager = new TypeBlockManager(component);
        }
        return manager;
    }

    public static void disableTypeBlockManager() {
        manager = null;
    }

    private TypeBlockManager() {
    }

    private TypeBlockManager(BlockCanvas component) {
        KeyInputMap.enableDefaultKeyMapping(false);
        this.autoCompletePanel = new AutoCompletePanel();
        this.blockCanvas = component;
        this.focusManager = Workspace.getInstance().getFocusManager();
        this.blockCanvas.getCanvas().addMouseListener(this.focusManager);
        this.blockCanvas.getCanvas().addKeyListener(this.focusManager);
        Workspace.getInstance().addWorkspaceListener(this.focusManager);
    }

    private static boolean invalidBlockID(Long blockID) {
        if (blockID == null) {
            return true;
        }
        return blockID.equals(Block.NULL);
    }

    private static boolean isNullBlockInstance(Long blockID) {
        if (blockID == null) {
            return true;
        }
        if (blockID.equals(Block.NULL)) {
            return true;
        }
        if (Block.getBlock(blockID) == null) {
            return true;
        }
        if (Block.getBlock(blockID).getBlockID() == null) {
            return true;
        }
        if (Block.getBlock(blockID).getBlockID().equals(Block.NULL)) {
            return true;
        }
        if (RenderableBlock.getRenderableBlock(blockID) == null) {
            return true;
        }
        if (RenderableBlock.getRenderableBlock(blockID).getBlockID() == null) {
            return true;
        }
        return RenderableBlock.getRenderableBlock(blockID).getBlockID().equals(Block.NULL);
    }

    protected static void automateBlockDeletion() {
        if (manager == null) {
            System.err.println("AutoMateBlockDeletion invoked but typeBlockManager is disabled.");
            return;
        }
        if (!TypeBlockManager.isNullBlockInstance(TypeBlockManager.manager.focusManager.getFocusBlockID())) {
            manager.deleteBlockAndChildren();
            PageChangeEventManager.notifyListeners();
        }
    }

    private void deleteBlockAndChildren() {
        if (TypeBlockManager.isNullBlockInstance(this.focusManager.getFocusBlockID())) {
            throw new RuntimeException("TypeBlockManager: deleting a null block references.");
        }
        Block block = Block.getBlock(this.focusManager.getFocusBlockID());
        RenderableBlock renderable = RenderableBlock.getRenderableBlock(block.getBlockID());
        WorkspaceWidget widget = renderable.getParentWidget();
        if (widget == null) {
            throw new RuntimeException("TypeBlockManager: do not delete blocks with no parent widget.");
        }
        Container container = renderable.getParent();
        if (container == null) {
            throw new RuntimeException("TypeBlockManager: do not delete blocks with no parent container.");
        }
        Point location = SwingUtilities.convertPoint(renderable, new Point(0, 0), this.blockCanvas.getCanvas());
        Long parentID = null;
        if (this.validConnection(block.getPlug())) {
            parentID = block.getPlugBlockID();
            this.disconnectBlock(block, widget);
            if (this.validConnection(block.getAfterConnector())) {
                this.disconnectBlock(Block.getBlock(block.getAfterBlockID()), widget);
            }
        } else if (this.validConnection(block.getBeforeConnector())) {
            parentID = block.getBeforeBlockID();
            BlockConnector parentConnectorToBlock = Block.getBlock(parentID).getConnectorTo(block.getBlockID());
            this.disconnectBlock(block, widget);
            if (this.validConnection(block.getAfterConnector())) {
                BlockLink link;
                Long afterBlockID = block.getAfterBlockID();
                this.disconnectBlock(Block.getBlock(afterBlockID), widget);
                if (parentID != null && (link = BlockLinkChecker.canLink(Block.getBlock(parentID), Block.getBlock(afterBlockID), parentConnectorToBlock, Block.getBlock(afterBlockID).getBeforeConnector())) != null) {
                    link.connect();
                    Workspace.getInstance().notifyListeners(new WorkspaceEvent(RenderableBlock.getRenderableBlock(link.getPlugBlockID()).getParentWidget(), link, 5));
                    RenderableBlock.getRenderableBlock(link.getPlugBlockID()).repaintBlock();
                    RenderableBlock.getRenderableBlock(link.getPlugBlockID()).repaint();
                    RenderableBlock.getRenderableBlock(link.getPlugBlockID()).moveConnectedBlocks();
                    RenderableBlock.getRenderableBlock(link.getSocketBlockID()).repaintBlock();
                    RenderableBlock.getRenderableBlock(link.getSocketBlockID()).repaint();
                }
            }
        } else if (this.validConnection(block.getAfterConnector())) {
            parentID = block.getAfterBlockID();
        }
        this.removeChildrenBlock(renderable, widget, container);
        if (TypeBlockManager.invalidBlockID(parentID)) {
            this.focusManager.setFocus(location, Block.NULL);
            this.blockCanvas.getCanvas().requestFocus();
            return;
        }
        this.focusManager.setFocus(parentID);
        this.blockCanvas.getCanvas().requestFocus();
    }

    private void removeChildrenBlock(RenderableBlock renderable, WorkspaceWidget widget, Container container) {
        widget.removeBlock(renderable);
        container.remove(renderable);
        container.validate();
        container.repaint();
        renderable.setParentWidget(null);
        for (BlockConnector child : Block.getBlock(renderable.getBlockID()).getSockets()) {
            RenderableBlock childRenderable;
            if (child == null || child.getBlockID().equals(Block.NULL) || (childRenderable = RenderableBlock.getRenderableBlock(child.getBlockID())) == null) continue;
            this.removeBlock(childRenderable, widget, container);
        }
        if (Block.getBlock(renderable.getBlockID()).isProcedureDeclBlock() && Block.getBlock(renderable.getBlockID()).getAfterBlockID() != Block.NULL) {
            this.removeAfterBlock(RenderableBlock.getRenderableBlock(Block.getBlock(renderable.getBlockID()).getAfterBlockID()), widget, container);
            this.disconnectBlock(Block.getBlock(Block.getBlock(renderable.getBlockID()).getAfterBlockID()), widget);
        }
        if (renderable.hasComment()) {
            renderable.removeComment();
        }
        Workspace.getInstance().notifyListeners(new WorkspaceEvent(widget, renderable.getBlockID(), 4));
    }

    private void removeAfterBlock(RenderableBlock afterBlock, WorkspaceWidget widget, Container container) {
        if (Block.getBlock(afterBlock.getBlockID()).getAfterBlockID() != Block.NULL) {
            this.removeAfterBlock(RenderableBlock.getRenderableBlock(Block.getBlock(afterBlock.getBlockID()).getAfterBlockID()), widget, container);
        }
        this.removeChildrenBlock(afterBlock, widget, container);
    }

    private boolean validConnection(BlockConnector connection) {
        Long blockID;
        return connection != null && !TypeBlockManager.isNullBlockInstance(blockID = connection.getBlockID()) && connection.hasBlock();
    }

    private void removeBlock(RenderableBlock renderable, WorkspaceWidget widget, Container container) {
        widget.removeBlock(renderable);
        container.remove(renderable);
        container.validate();
        container.repaint();
        renderable.setParentWidget(null);
        for (BlockConnector child : BlockLinkChecker.getSocketEquivalents(Block.getBlock(renderable.getBlockID()))) {
            RenderableBlock childRenderable;
            if (child == null || child.getBlockID().equals(Block.NULL) || (childRenderable = RenderableBlock.getRenderableBlock(child.getBlockID())) == null) continue;
            this.removeBlock(childRenderable, widget, container);
        }
        if (renderable.hasComment()) {
            renderable.removeComment();
        }
        Workspace.getInstance().notifyListeners(new WorkspaceEvent(widget, renderable.getBlockID(), 4));
    }

    private void disconnectBlock(Block childBlock, WorkspaceWidget widget) {
        if (childBlock == null || TypeBlockManager.invalidBlockID(childBlock.getBlockID())) {
            return;
        }
        BlockConnector childPlug = BlockLinkChecker.getPlugEquivalent(childBlock);
        if (childPlug == null || !childPlug.hasBlock() || TypeBlockManager.isNullBlockInstance(childPlug.getBlockID())) {
            return;
        }
        Block parentBlock = Block.getBlock(childPlug.getBlockID());
        BlockConnector parentSocket = parentBlock.getConnectorTo(childBlock.getBlockID());
        if (parentSocket == null) {
            return;
        }
        BlockLink link = BlockLink.getBlockLink(childBlock, parentBlock, childPlug, parentSocket);
        if (link == null) {
            return;
        }
        link.disconnect();
        RenderableBlock parentRenderable = RenderableBlock.getRenderableBlock(parentBlock.getBlockID());
        if (parentRenderable == null) {
            throw new RuntimeException("INCONSISTANCY VIOLATION: parent block was valid, non-null, and existed.\n\tBut yet, when we get it's renderablerepresentation, we recieve a null instance.\n\tIf the Block instance of an ID is non-nullthen its graphical RenderableBlock should be non-null as well");
        }
        parentRenderable.blockDisconnected(parentSocket);
        Workspace.getInstance().notifyListeners(new WorkspaceEvent(widget, link, 6));
    }

    public static void copyBlock() {
        TypeBlockManager.automateCopyBlock();
    }

    public static void pasteBlock() {
        TypeBlockManager.automatePasteBlock();
    }

    protected static void automateCopyBlock() {
        if (manager == null) {
            System.err.println("AutoMateCopyBlock invoked but typeBlockManager is disabled.");
            return;
        }
        TypeBlockManager.manager.bufferedBlock = BlockUtilities.makeNodeWithChildren(TypeBlockManager.manager.focusManager.getFocusBlockID());
    }

    protected static void automateCopyAll() {
        if (manager == null) {
            System.err.println("AutoMatePasteBlock invoked but typeBlockManager is disabled.");
            return;
        }
        TypeBlockManager.manager.bufferedBlock = BlockUtilities.makeNodeWithStack(TypeBlockManager.manager.focusManager.getFocusBlockID());
    }

    protected static void automatePasteBlock() {
        if (manager == null) {
            System.err.println("AutoMatePasteBlock invoked but typeBlockManager is disabled.");
            return;
        }
        manager.pasteStack(TypeBlockManager.manager.bufferedBlock);
    }

    private void pasteStack(BlockNode node) {
        if (node == null) {
            return;
        }
        WorkspaceWidget widget = null;
        Object widgets = null;
        Point spot = null;
        if (TypeBlockManager.invalidBlockID(this.focusManager.getFocusBlockID())) {
            Point location = SwingUtilities.convertPoint(this.blockCanvas.getCanvas(), this.focusManager.getCanvasPoint(), Workspace.getInstance());
            widget = Workspace.getInstance().getWidgetAt(location);
            spot = SwingUtilities.convertPoint(this.blockCanvas.getCanvas(), this.focusManager.getCanvasPoint(), widget.getJComponent());
        } else {
            RenderableBlock focusRenderable = RenderableBlock.getRenderableBlock(this.focusManager.getFocusBlockID());
            widget = focusRenderable.getParentWidget();
            spot = focusRenderable.getLocation();
        }
        if (widget == null) {
            JOptionPane.showMessageDialog(TypeBlockManager.manager.frame, "Please click somewhere on the canvas first.", "Error", -1);
        } else if (BlockUtilities.blockExists(node)) {
            spot.translate(10, 10);
            RenderableBlock mirror = BlockUtilities.makeRenderable(node, widget);
            mirror.setLocation(spot);
            mirror.moveConnectedBlocks();
        } else {
            JOptionPane.showMessageDialog(TypeBlockManager.manager.frame, "You cannot paste blocks that are currently NOT on the canvas.\nThis function will be available in a future version.\n", "Error", -1);
        }
    }

    protected static void automateFocusTraversal(Direction dir) {
        if (manager == null) {
            System.err.println("AutoMateFocusTraversal invoked but typeBlockManager is disabled.");
            return;
        }
        manager.traverseFocus(dir);
    }

    private void traverseFocus(Direction dir) {
        if (TypeBlockManager.isNullBlockInstance(this.focusManager.getFocusBlockID())) {
            if (dir == Direction.UP) {
                this.blockCanvas.getVerticalModel().setValue(this.blockCanvas.getVerticalModel().getValue() - 5);
            } else if (dir == Direction.DOWN) {
                this.blockCanvas.getVerticalModel().setValue(this.blockCanvas.getVerticalModel().getValue() + 5);
            } else if (dir == Direction.LEFT) {
                this.blockCanvas.getHorizontalModel().setValue(this.blockCanvas.getHorizontalModel().getValue() - 5);
            } else if (dir == Direction.RIGHT) {
                this.blockCanvas.getHorizontalModel().setValue(this.blockCanvas.getHorizontalModel().getValue() + 5);
            } else if (dir == Direction.ESCAPE) {
                this.blockCanvas.getCanvas().requestFocus();
            } else if (dir == Direction.ENTER) {
                // empty if block
            }
        } else if (dir == Direction.UP) {
            this.focusManager.focusBeforeBlock();
        } else if (dir == Direction.DOWN) {
            this.focusManager.focusAfterBlock();
        } else if (dir == Direction.LEFT) {
            this.focusManager.focusPrevBlock();
        } else if (dir == Direction.RIGHT) {
            this.focusManager.focusNextBlock();
        } else if (dir == Direction.ESCAPE) {
            RenderableBlock block = RenderableBlock.getRenderableBlock(this.focusManager.getFocusBlockID());
            Point location = SwingUtilities.convertPoint(block, new Point(0, 0), this.blockCanvas.getCanvas());
            this.focusManager.setFocus(location, Block.NULL);
            this.blockCanvas.getCanvas().requestFocus();
        } else if (dir == Direction.ENTER) {
            RenderableBlock.getRenderableBlock(this.focusManager.getFocusBlockID()).switchToLabelEditingMode(true);
        }
    }

    protected static void automateAutoComplete(char character) {
        if (manager == null) {
            System.err.println("AutoMateAutoComplete invoked but typeBlockManager is disabled.");
            return;
        }
        manager.displayAutoCompletePanel(character);
    }

    private void displayAutoCompletePanel(char character) {
        if (TypeBlockManager.invalidBlockID(this.focusManager.getFocusBlockID())) {
            this.blockCanvas.getCanvas().add((Component)this.autoCompletePanel, JLayeredPane.DRAG_LAYER);
            this.autoCompletePanel.setLocation(this.focusManager.getCanvasPoint());
            this.autoCompletePanel.setVisible(true);
            this.autoCompletePanel.requestFocus();
        } else {
            this.blockCanvas.getCanvas().add((Component)this.autoCompletePanel, JLayeredPane.DRAG_LAYER);
            RenderableBlock block = RenderableBlock.getRenderableBlock(this.focusManager.getFocusBlockID());
            Point location = SwingUtilities.convertPoint(block, this.focusManager.getBlockPoint(), this.blockCanvas.getCanvas());
            location.translate(10, 10);
            this.autoCompletePanel.setLocation(location);
            this.autoCompletePanel.setVisible(true);
            this.autoCompletePanel.requestFocus();
        }
        this.autoCompletePanel.setText(String.valueOf(character));
    }

    protected static void automateNegationInsertion() {
        if (manager == null) {
            System.err.println("AutoMateNegationInsertion invoked but typeBlockManager is disabled.");
            return;
        }
        Long parentBlockID = TypeBlockManager.manager.focusManager.getFocusBlockID();
        if (TypeBlockManager.isNullBlockInstance(parentBlockID)) {
            TypeBlockManager.automateBlockInsertion("number", "-");
        } else {
            Block parentBlock = Block.getBlock(parentBlockID);
            if (parentBlock.isDataBlock()) {
                TypeBlockManager.automateBlockInsertion("difference", null);
            } else {
                TypeBlockManager.automateBlockInsertion("number", "-");
            }
        }
    }

    protected static void automateMultiplication(char character) {
        Block parentBlock;
        if (manager == null) {
            System.err.println("AutoMateMultiplication invoked but typeBlockManager is disabled.");
            return;
        }
        if (!TypeBlockManager.isNullBlockInstance(TypeBlockManager.manager.focusManager.getFocusBlockID()) && (parentBlock = Block.getBlock(TypeBlockManager.manager.focusManager.getFocusBlockID())).getGenusName().equals("number")) {
            TypeBlockManager.automateBlockInsertion("product", null);
            return;
        }
        TypeBlockManager.automateAutoComplete(character);
    }

    protected static void automateAddition(char character) {
        if (manager == null) {
            System.err.println("AutoMateMultiplication invoked but typeBlockManager is disabled.");
            return;
        }
        Long parentBlockID = TypeBlockManager.manager.focusManager.getFocusBlockID();
        if (TypeBlockManager.isNullBlockInstance(parentBlockID)) {
            TypeBlockManager.automateBlockInsertion("sum", null);
        } else {
            Block parentBlock = Block.getBlock(parentBlockID);
            if (parentBlock.getGenusName().equals("string")) {
                TypeBlockManager.automateBlockInsertion("string-append", null);
            } else if (parentBlock.getGenusName().equals("string-append")) {
                TypeBlockManager.automateBlockInsertion("string-append", null);
            } else {
                TypeBlockManager.automateBlockInsertion("sum", null);
            }
        }
    }

    protected static void automateBlockInsertion(String genusName, String label) {
        if (manager == null) {
            System.err.println("AutoMateBlockInsertion invoked but typeBlockManager is disabled.");
            return;
        }
        if (genusName == null) {
            return;
        }
        RenderableBlock createdRB = BlockUtilities.getBlock(genusName, null);
        if (createdRB == null) {
            return;
        }
        if (label != null && Block.getBlock(createdRB.getBlockID()).isLabelEditable() && !Block.getBlock(createdRB.getBlockID()).labelMustBeUnique()) {
            Block.getBlock(createdRB.getBlockID()).setBlockLabel(label);
        }
        manager.addBlock(createdRB);
    }

    protected static void automateBlockInsertion(TextualFactoryBlock block) {
        TypeBlockManager.automateBlockInsertion(block, EMPTY_LABEL_NAME);
    }

    protected static void automateBlockInsertion(TextualFactoryBlock block, String label) {
        if (manager == null) {
            System.err.println("AutoMateBlockInsertion invoked but typeBlockManager is disabled.");
            return;
        }
        RenderableBlock createdRB = TypeBlockManager.createRenderableBlock(block);
        if (label != EMPTY_LABEL_NAME) {
            createdRB.getBlock().setBlockLabel(label);
        }
        if (label.equals(NUMBER_PLUS_OPERATION_LABEL)) {
            createdRB.getBlock().setBlockLabel(PLUS_OPERATION_LABEL);
        }
        if (label.equals(TEXT_PLUS_OPERATION_LABEL)) {
            createdRB.getBlock().setBlockLabel(PLUS_OPERATION_LABEL);
        }
        if (createdRB == null) {
            return;
        }
        manager.addBlock(createdRB);
    }

    private static RenderableBlock createRenderableBlock(TextualFactoryBlock block) {
        if (block == null) {
            return null;
        }
        if (block.getfactoryBlock() == null || block.getfactoryBlock().getBlockID().equals(Block.NULL)) {
            return null;
        }
        RenderableBlock createdRB = block.getfactoryBlock().createNewInstance();
        if (createdRB == null || TypeBlockManager.isNullBlockInstance(createdRB.getBlockID())) {
            throw new RuntimeException("Invariant Violated:May not drop null instances of Renderable Blocks");
        }
        return createdRB;
    }

    private void addBlock(RenderableBlock block) {
        if (block == null || block.getBlockID() == null || block.getBlockID().equals(Block.NULL) || Block.getBlock(block.getBlockID()) == null || Block.getBlock(block.getBlockID()).getGenusName() == null || Block.getBlock(block.getBlockID()).getGenusName().length() == 0 || Block.getBlock(block.getBlockID()).getBlockLabel() == null) {
            throw new RuntimeException("Invariant Violated: may not pass an invalid instance of renderabel block");
        }
        block.ignoreDefaultArguments();
        this.blockCanvas.getCanvas().add((Component)block, 0);
        block.setLocation(0, 0);
        Long parentBlockID = this.focusManager.getFocusBlockID();
        if (TypeBlockManager.invalidBlockID(parentBlockID)) {
            new BlockDropAnimator(this.focusManager.getCanvasPoint(), block, RenderableBlock.getRenderableBlock(parentBlockID));
        } else {
            RenderableBlock parentBlock = RenderableBlock.getRenderableBlock(parentBlockID);
            new BlockDropAnimator(SwingUtilities.convertPoint(parentBlock, this.focusManager.getBlockPoint(), this.blockCanvas.getCanvas()), block, RenderableBlock.getRenderableBlock(parentBlockID));
        }
        this.focusManager.setFocus(block.getBlockID());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        ESCAPE,
        ENTER;

    }
}

